﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/finspace/model/ListKxDataviewsResult.h>

#include <utility>

using namespace Aws::finspace::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListKxDataviewsResult::ListKxDataviewsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListKxDataviewsResult& ListKxDataviewsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("kxDataviews")) {
    Aws::Utils::Array<JsonView> kxDataviewsJsonList = jsonValue.GetArray("kxDataviews");
    for (unsigned kxDataviewsIndex = 0; kxDataviewsIndex < kxDataviewsJsonList.GetLength(); ++kxDataviewsIndex) {
      m_kxDataviews.push_back(kxDataviewsJsonList[kxDataviewsIndex].AsObject());
    }
    m_kxDataviewsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
