﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/finspace/model/UpdateKxDataviewResult.h>

#include <utility>

using namespace Aws::finspace::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

UpdateKxDataviewResult::UpdateKxDataviewResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

UpdateKxDataviewResult& UpdateKxDataviewResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("environmentId")) {
    m_environmentId = jsonValue.GetString("environmentId");
    m_environmentIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("databaseName")) {
    m_databaseName = jsonValue.GetString("databaseName");
    m_databaseNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("dataviewName")) {
    m_dataviewName = jsonValue.GetString("dataviewName");
    m_dataviewNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("azMode")) {
    m_azMode = KxAzModeMapper::GetKxAzModeForName(jsonValue.GetString("azMode"));
    m_azModeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("availabilityZoneId")) {
    m_availabilityZoneId = jsonValue.GetString("availabilityZoneId");
    m_availabilityZoneIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("changesetId")) {
    m_changesetId = jsonValue.GetString("changesetId");
    m_changesetIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("segmentConfigurations")) {
    Aws::Utils::Array<JsonView> segmentConfigurationsJsonList = jsonValue.GetArray("segmentConfigurations");
    for (unsigned segmentConfigurationsIndex = 0; segmentConfigurationsIndex < segmentConfigurationsJsonList.GetLength();
         ++segmentConfigurationsIndex) {
      m_segmentConfigurations.push_back(segmentConfigurationsJsonList[segmentConfigurationsIndex].AsObject());
    }
    m_segmentConfigurationsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("activeVersions")) {
    Aws::Utils::Array<JsonView> activeVersionsJsonList = jsonValue.GetArray("activeVersions");
    for (unsigned activeVersionsIndex = 0; activeVersionsIndex < activeVersionsJsonList.GetLength(); ++activeVersionsIndex) {
      m_activeVersions.push_back(activeVersionsJsonList[activeVersionsIndex].AsObject());
    }
    m_activeVersionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("status")) {
    m_status = KxDataviewStatusMapper::GetKxDataviewStatusForName(jsonValue.GetString("status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("autoUpdate")) {
    m_autoUpdate = jsonValue.GetBool("autoUpdate");
    m_autoUpdateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("readWrite")) {
    m_readWrite = jsonValue.GetBool("readWrite");
    m_readWriteHasBeenSet = true;
  }
  if (jsonValue.ValueExists("description")) {
    m_description = jsonValue.GetString("description");
    m_descriptionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("createdTimestamp")) {
    m_createdTimestamp = jsonValue.GetDouble("createdTimestamp");
    m_createdTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("lastModifiedTimestamp")) {
    m_lastModifiedTimestamp = jsonValue.GetDouble("lastModifiedTimestamp");
    m_lastModifiedTimestampHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
