﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/firehose/model/AmazonOpenSearchServerlessDestinationUpdate.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Firehose {
namespace Model {

AmazonOpenSearchServerlessDestinationUpdate::AmazonOpenSearchServerlessDestinationUpdate(JsonView jsonValue) { *this = jsonValue; }

AmazonOpenSearchServerlessDestinationUpdate& AmazonOpenSearchServerlessDestinationUpdate::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("RoleARN")) {
    m_roleARN = jsonValue.GetString("RoleARN");
    m_roleARNHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CollectionEndpoint")) {
    m_collectionEndpoint = jsonValue.GetString("CollectionEndpoint");
    m_collectionEndpointHasBeenSet = true;
  }
  if (jsonValue.ValueExists("IndexName")) {
    m_indexName = jsonValue.GetString("IndexName");
    m_indexNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("BufferingHints")) {
    m_bufferingHints = jsonValue.GetObject("BufferingHints");
    m_bufferingHintsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RetryOptions")) {
    m_retryOptions = jsonValue.GetObject("RetryOptions");
    m_retryOptionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("S3Update")) {
    m_s3Update = jsonValue.GetObject("S3Update");
    m_s3UpdateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ProcessingConfiguration")) {
    m_processingConfiguration = jsonValue.GetObject("ProcessingConfiguration");
    m_processingConfigurationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CloudWatchLoggingOptions")) {
    m_cloudWatchLoggingOptions = jsonValue.GetObject("CloudWatchLoggingOptions");
    m_cloudWatchLoggingOptionsHasBeenSet = true;
  }
  return *this;
}

JsonValue AmazonOpenSearchServerlessDestinationUpdate::Jsonize() const {
  JsonValue payload;

  if (m_roleARNHasBeenSet) {
    payload.WithString("RoleARN", m_roleARN);
  }

  if (m_collectionEndpointHasBeenSet) {
    payload.WithString("CollectionEndpoint", m_collectionEndpoint);
  }

  if (m_indexNameHasBeenSet) {
    payload.WithString("IndexName", m_indexName);
  }

  if (m_bufferingHintsHasBeenSet) {
    payload.WithObject("BufferingHints", m_bufferingHints.Jsonize());
  }

  if (m_retryOptionsHasBeenSet) {
    payload.WithObject("RetryOptions", m_retryOptions.Jsonize());
  }

  if (m_s3UpdateHasBeenSet) {
    payload.WithObject("S3Update", m_s3Update.Jsonize());
  }

  if (m_processingConfigurationHasBeenSet) {
    payload.WithObject("ProcessingConfiguration", m_processingConfiguration.Jsonize());
  }

  if (m_cloudWatchLoggingOptionsHasBeenSet) {
    payload.WithObject("CloudWatchLoggingOptions", m_cloudWatchLoggingOptions.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace Firehose
}  // namespace Aws
