﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/firehose/model/Processor.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Firehose {
namespace Model {

Processor::Processor(JsonView jsonValue) { *this = jsonValue; }

Processor& Processor::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Type")) {
    m_type = ProcessorTypeMapper::GetProcessorTypeForName(jsonValue.GetString("Type"));
    m_typeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Parameters")) {
    Aws::Utils::Array<JsonView> parametersJsonList = jsonValue.GetArray("Parameters");
    for (unsigned parametersIndex = 0; parametersIndex < parametersJsonList.GetLength(); ++parametersIndex) {
      m_parameters.push_back(parametersJsonList[parametersIndex].AsObject());
    }
    m_parametersHasBeenSet = true;
  }
  return *this;
}

JsonValue Processor::Jsonize() const {
  JsonValue payload;

  if (m_typeHasBeenSet) {
    payload.WithString("Type", ProcessorTypeMapper::GetNameForProcessorType(m_type));
  }

  if (m_parametersHasBeenSet) {
    Aws::Utils::Array<JsonValue> parametersJsonList(m_parameters.size());
    for (unsigned parametersIndex = 0; parametersIndex < parametersJsonList.GetLength(); ++parametersIndex) {
      parametersJsonList[parametersIndex].AsObject(m_parameters[parametersIndex].Jsonize());
    }
    payload.WithArray("Parameters", std::move(parametersJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace Firehose
}  // namespace Aws
