﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/firehose/model/UntagDeliveryStreamRequest.h>

#include <utility>

using namespace Aws::Firehose::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UntagDeliveryStreamRequest::SerializePayload() const {
  JsonValue payload;

  if (m_deliveryStreamNameHasBeenSet) {
    payload.WithString("DeliveryStreamName", m_deliveryStreamName);
  }

  if (m_tagKeysHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagKeysJsonList(m_tagKeys.size());
    for (unsigned tagKeysIndex = 0; tagKeysIndex < tagKeysJsonList.GetLength(); ++tagKeysIndex) {
      tagKeysJsonList[tagKeysIndex].AsString(m_tagKeys[tagKeysIndex]);
    }
    payload.WithArray("TagKeys", std::move(tagKeysJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UntagDeliveryStreamRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Firehose_20150804.UntagDeliveryStream"));
  return headers;
}
