﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/inspector/model/FailedItemDetails.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Inspector {
namespace Model {

FailedItemDetails::FailedItemDetails(JsonView jsonValue) { *this = jsonValue; }

FailedItemDetails& FailedItemDetails::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("failureCode")) {
    m_failureCode = FailedItemErrorCodeMapper::GetFailedItemErrorCodeForName(jsonValue.GetString("failureCode"));
    m_failureCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("retryable")) {
    m_retryable = jsonValue.GetBool("retryable");
    m_retryableHasBeenSet = true;
  }
  return *this;
}

JsonValue FailedItemDetails::Jsonize() const {
  JsonValue payload;

  if (m_failureCodeHasBeenSet) {
    payload.WithString("failureCode", FailedItemErrorCodeMapper::GetNameForFailedItemErrorCode(m_failureCode));
  }

  if (m_retryableHasBeenSet) {
    payload.WithBool("retryable", m_retryable);
  }

  return payload;
}

}  // namespace Model
}  // namespace Inspector
}  // namespace Aws
