﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/client/AWSError.h>
#include <aws/iot/IoTErrorMarshaller.h>
#include <aws/iot/IoTErrors.h>

using namespace Aws::Client;
using namespace Aws::IoT;

AWSError<CoreErrors> IoTErrorMarshaller::FindErrorByName(const char* errorName) const {
  AWSError<CoreErrors> error = IoTErrorMapper::GetErrorForName(errorName);
  if (error.GetErrorType() != CoreErrors::UNKNOWN) {
    return error;
  }

  return AWSErrorMarshaller::FindErrorByName(errorName);
}