﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/iot/model/AbortAction.h>

using namespace Aws::Utils;

namespace Aws {
namespace IoT {
namespace Model {
namespace AbortActionMapper {

static const int CANCEL_HASH = HashingUtils::HashString("CANCEL");

AbortAction GetAbortActionForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == CANCEL_HASH) {
    return AbortAction::CANCEL;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<AbortAction>(hashCode);
  }

  return AbortAction::NOT_SET;
}

Aws::String GetNameForAbortAction(AbortAction enumValue) {
  switch (enumValue) {
    case AbortAction::NOT_SET:
      return {};
    case AbortAction::CANCEL:
      return "CANCEL";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace AbortActionMapper
}  // namespace Model
}  // namespace IoT
}  // namespace Aws
