﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/iot/model/AlertTargetType.h>

using namespace Aws::Utils;

namespace Aws {
namespace IoT {
namespace Model {
namespace AlertTargetTypeMapper {

static const int SNS_HASH = HashingUtils::HashString("SNS");

AlertTargetType GetAlertTargetTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == SNS_HASH) {
    return AlertTargetType::SNS;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<AlertTargetType>(hashCode);
  }

  return AlertTargetType::NOT_SET;
}

Aws::String GetNameForAlertTargetType(AlertTargetType enumValue) {
  switch (enumValue) {
    case AlertTargetType::NOT_SET:
      return {};
    case AlertTargetType::SNS:
      return "SNS";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace AlertTargetTypeMapper
}  // namespace Model
}  // namespace IoT
}  // namespace Aws
