﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iot/model/AttachPolicyRequest.h>

#include <utility>

using namespace Aws::IoT::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String AttachPolicyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_targetHasBeenSet) {
    payload.WithString("target", m_target);
  }

  return payload.View().WriteReadable();
}
