﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/HashingUtils.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iot/model/CommandPayload.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace IoT {
namespace Model {

CommandPayload::CommandPayload(JsonView jsonValue) { *this = jsonValue; }

CommandPayload& CommandPayload::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("content")) {
    m_content = HashingUtils::Base64Decode(jsonValue.GetString("content"));
    m_contentHasBeenSet = true;
  }
  if (jsonValue.ValueExists("contentType")) {
    m_contentType = jsonValue.GetString("contentType");
    m_contentTypeHasBeenSet = true;
  }
  return *this;
}

JsonValue CommandPayload::Jsonize() const {
  JsonValue payload;

  if (m_contentHasBeenSet) {
    payload.WithString("content", HashingUtils::Base64Encode(m_content));
  }

  if (m_contentTypeHasBeenSet) {
    payload.WithString("contentType", m_contentType);
  }

  return payload;
}

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
