﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/iot/model/CreateDynamicThingGroupResult.h>

#include <utility>

using namespace Aws::IoT::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreateDynamicThingGroupResult::CreateDynamicThingGroupResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

CreateDynamicThingGroupResult& CreateDynamicThingGroupResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("thingGroupName")) {
    m_thingGroupName = jsonValue.GetString("thingGroupName");
    m_thingGroupNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("thingGroupArn")) {
    m_thingGroupArn = jsonValue.GetString("thingGroupArn");
    m_thingGroupArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("thingGroupId")) {
    m_thingGroupId = jsonValue.GetString("thingGroupId");
    m_thingGroupIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("indexName")) {
    m_indexName = jsonValue.GetString("indexName");
    m_indexNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("queryString")) {
    m_queryString = jsonValue.GetString("queryString");
    m_queryStringHasBeenSet = true;
  }
  if (jsonValue.ValueExists("queryVersion")) {
    m_queryVersion = jsonValue.GetString("queryVersion");
    m_queryVersionHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
