﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/iot/model/DescribeThingResult.h>

#include <utility>

using namespace Aws::IoT::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeThingResult::DescribeThingResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeThingResult& DescribeThingResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("defaultClientId")) {
    m_defaultClientId = jsonValue.GetString("defaultClientId");
    m_defaultClientIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("thingName")) {
    m_thingName = jsonValue.GetString("thingName");
    m_thingNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("thingId")) {
    m_thingId = jsonValue.GetString("thingId");
    m_thingIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("thingArn")) {
    m_thingArn = jsonValue.GetString("thingArn");
    m_thingArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("thingTypeName")) {
    m_thingTypeName = jsonValue.GetString("thingTypeName");
    m_thingTypeNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("attributes")) {
    Aws::Map<Aws::String, JsonView> attributesJsonMap = jsonValue.GetObject("attributes").GetAllObjects();
    for (auto& attributesItem : attributesJsonMap) {
      m_attributes[attributesItem.first] = attributesItem.second.AsString();
    }
    m_attributesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("version")) {
    m_version = jsonValue.GetInt64("version");
    m_versionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("billingGroupName")) {
    m_billingGroupName = jsonValue.GetString("billingGroupName");
    m_billingGroupNameHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
