﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/iot/model/GetV2LoggingOptionsResult.h>

#include <utility>

using namespace Aws::IoT::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetV2LoggingOptionsResult::GetV2LoggingOptionsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetV2LoggingOptionsResult& GetV2LoggingOptionsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("roleArn")) {
    m_roleArn = jsonValue.GetString("roleArn");
    m_roleArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("defaultLogLevel")) {
    m_defaultLogLevel = LogLevelMapper::GetLogLevelForName(jsonValue.GetString("defaultLogLevel"));
    m_defaultLogLevelHasBeenSet = true;
  }
  if (jsonValue.ValueExists("disableAllLogs")) {
    m_disableAllLogs = jsonValue.GetBool("disableAllLogs");
    m_disableAllLogsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("eventConfigurations")) {
    Aws::Utils::Array<JsonView> eventConfigurationsJsonList = jsonValue.GetArray("eventConfigurations");
    for (unsigned eventConfigurationsIndex = 0; eventConfigurationsIndex < eventConfigurationsJsonList.GetLength();
         ++eventConfigurationsIndex) {
      m_eventConfigurations.push_back(eventConfigurationsJsonList[eventConfigurationsIndex].AsObject());
    }
    m_eventConfigurationsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
