﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iot/model/HttpAction.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace IoT {
namespace Model {

HttpAction::HttpAction(JsonView jsonValue) { *this = jsonValue; }

HttpAction& HttpAction::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("url")) {
    m_url = jsonValue.GetString("url");
    m_urlHasBeenSet = true;
  }
  if (jsonValue.ValueExists("confirmationUrl")) {
    m_confirmationUrl = jsonValue.GetString("confirmationUrl");
    m_confirmationUrlHasBeenSet = true;
  }
  if (jsonValue.ValueExists("headers")) {
    Aws::Utils::Array<JsonView> headersJsonList = jsonValue.GetArray("headers");
    for (unsigned headersIndex = 0; headersIndex < headersJsonList.GetLength(); ++headersIndex) {
      m_headers.push_back(headersJsonList[headersIndex].AsObject());
    }
    m_headersHasBeenSet = true;
  }
  if (jsonValue.ValueExists("auth")) {
    m_auth = jsonValue.GetObject("auth");
    m_authHasBeenSet = true;
  }
  if (jsonValue.ValueExists("enableBatching")) {
    m_enableBatching = jsonValue.GetBool("enableBatching");
    m_enableBatchingHasBeenSet = true;
  }
  if (jsonValue.ValueExists("batchConfig")) {
    m_batchConfig = jsonValue.GetObject("batchConfig");
    m_batchConfigHasBeenSet = true;
  }
  return *this;
}

JsonValue HttpAction::Jsonize() const {
  JsonValue payload;

  if (m_urlHasBeenSet) {
    payload.WithString("url", m_url);
  }

  if (m_confirmationUrlHasBeenSet) {
    payload.WithString("confirmationUrl", m_confirmationUrl);
  }

  if (m_headersHasBeenSet) {
    Aws::Utils::Array<JsonValue> headersJsonList(m_headers.size());
    for (unsigned headersIndex = 0; headersIndex < headersJsonList.GetLength(); ++headersIndex) {
      headersJsonList[headersIndex].AsObject(m_headers[headersIndex].Jsonize());
    }
    payload.WithArray("headers", std::move(headersJsonList));
  }

  if (m_authHasBeenSet) {
    payload.WithObject("auth", m_auth.Jsonize());
  }

  if (m_enableBatchingHasBeenSet) {
    payload.WithBool("enableBatching", m_enableBatching);
  }

  if (m_batchConfigHasBeenSet) {
    payload.WithObject("batchConfig", m_batchConfig.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
