﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iot/model/IotEventsAction.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace IoT {
namespace Model {

IotEventsAction::IotEventsAction(JsonView jsonValue) { *this = jsonValue; }

IotEventsAction& IotEventsAction::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("inputName")) {
    m_inputName = jsonValue.GetString("inputName");
    m_inputNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("messageId")) {
    m_messageId = jsonValue.GetString("messageId");
    m_messageIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("batchMode")) {
    m_batchMode = jsonValue.GetBool("batchMode");
    m_batchModeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("roleArn")) {
    m_roleArn = jsonValue.GetString("roleArn");
    m_roleArnHasBeenSet = true;
  }
  return *this;
}

JsonValue IotEventsAction::Jsonize() const {
  JsonValue payload;

  if (m_inputNameHasBeenSet) {
    payload.WithString("inputName", m_inputName);
  }

  if (m_messageIdHasBeenSet) {
    payload.WithString("messageId", m_messageId);
  }

  if (m_batchModeHasBeenSet) {
    payload.WithBool("batchMode", m_batchMode);
  }

  if (m_roleArnHasBeenSet) {
    payload.WithString("roleArn", m_roleArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
