﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iot/model/ListAuditSuppressionsRequest.h>

#include <utility>

using namespace Aws::IoT::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ListAuditSuppressionsRequest::SerializePayload() const {
  JsonValue payload;

  if (m_checkNameHasBeenSet) {
    payload.WithString("checkName", m_checkName);
  }

  if (m_resourceIdentifierHasBeenSet) {
    payload.WithObject("resourceIdentifier", m_resourceIdentifier.Jsonize());
  }

  if (m_ascendingOrderHasBeenSet) {
    payload.WithBool("ascendingOrder", m_ascendingOrder);
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("nextToken", m_nextToken);
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("maxResults", m_maxResults);
  }

  return payload.View().WriteReadable();
}
