﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iot/model/PutVerificationStateOnViolationRequest.h>

#include <utility>

using namespace Aws::IoT::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String PutVerificationStateOnViolationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_verificationStateHasBeenSet) {
    payload.WithString("verificationState", VerificationStateMapper::GetNameForVerificationState(m_verificationState));
  }

  if (m_verificationStateDescriptionHasBeenSet) {
    payload.WithString("verificationStateDescription", m_verificationStateDescription);
  }

  return payload.View().WriteReadable();
}
