﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iot/model/ServerCertificateSummary.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace IoT {
namespace Model {

ServerCertificateSummary::ServerCertificateSummary(JsonView jsonValue) { *this = jsonValue; }

ServerCertificateSummary& ServerCertificateSummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("serverCertificateArn")) {
    m_serverCertificateArn = jsonValue.GetString("serverCertificateArn");
    m_serverCertificateArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("serverCertificateStatus")) {
    m_serverCertificateStatus =
        ServerCertificateStatusMapper::GetServerCertificateStatusForName(jsonValue.GetString("serverCertificateStatus"));
    m_serverCertificateStatusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("serverCertificateStatusDetail")) {
    m_serverCertificateStatusDetail = jsonValue.GetString("serverCertificateStatusDetail");
    m_serverCertificateStatusDetailHasBeenSet = true;
  }
  return *this;
}

JsonValue ServerCertificateSummary::Jsonize() const {
  JsonValue payload;

  if (m_serverCertificateArnHasBeenSet) {
    payload.WithString("serverCertificateArn", m_serverCertificateArn);
  }

  if (m_serverCertificateStatusHasBeenSet) {
    payload.WithString("serverCertificateStatus",
                       ServerCertificateStatusMapper::GetNameForServerCertificateStatus(m_serverCertificateStatus));
  }

  if (m_serverCertificateStatusDetailHasBeenSet) {
    payload.WithString("serverCertificateStatusDetail", m_serverCertificateStatusDetail);
  }

  return payload;
}

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
