﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/iot/model/UpdatePackageVersionRequest.h>

#include <utility>

using namespace Aws::IoT::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String UpdatePackageVersionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_descriptionHasBeenSet) {
    payload.WithString("description", m_description);
  }

  if (m_attributesHasBeenSet) {
    JsonValue attributesJsonMap;
    for (auto& attributesItem : m_attributes) {
      attributesJsonMap.WithString(attributesItem.first, attributesItem.second);
    }
    payload.WithObject("attributes", std::move(attributesJsonMap));
  }

  if (m_artifactHasBeenSet) {
    payload.WithObject("artifact", m_artifact.Jsonize());
  }

  if (m_actionHasBeenSet) {
    payload.WithString("action", PackageVersionActionMapper::GetNameForPackageVersionAction(m_action));
  }

  if (m_recipeHasBeenSet) {
    payload.WithString("recipe", m_recipe);
  }

  return payload.View().WriteReadable();
}

void UpdatePackageVersionRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_clientTokenHasBeenSet) {
    ss << m_clientToken;
    uri.AddQueryStringParameter("clientToken", ss.str());
    ss.str("");
  }
}
