﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iot/model/UpdateThingGroupRequest.h>

#include <utility>

using namespace Aws::IoT::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateThingGroupRequest::SerializePayload() const {
  JsonValue payload;

  if (m_thingGroupPropertiesHasBeenSet) {
    payload.WithObject("thingGroupProperties", m_thingGroupProperties.Jsonize());
  }

  if (m_expectedVersionHasBeenSet) {
    payload.WithInt64("expectedVersion", m_expectedVersion);
  }

  return payload.View().WriteReadable();
}
