﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/logs/model/DisassociateKmsKeyRequest.h>

#include <utility>

using namespace Aws::CloudWatchLogs::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DisassociateKmsKeyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_logGroupNameHasBeenSet) {
    payload.WithString("logGroupName", m_logGroupName);
  }

  if (m_resourceIdentifierHasBeenSet) {
    payload.WithString("resourceIdentifier", m_resourceIdentifier);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DisassociateKmsKeyRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Logs_20140328.DisassociateKmsKey"));
  return headers;
}
