﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/m2/model/CancelBatchJobExecutionRequest.h>

#include <utility>

using namespace Aws::MainframeModernization::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CancelBatchJobExecutionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_authSecretsManagerArnHasBeenSet) {
    payload.WithString("authSecretsManagerArn", m_authSecretsManagerArn);
  }

  return payload.View().WriteReadable();
}
