﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/m2/model/DataSetImportTask.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MainframeModernization {
namespace Model {

DataSetImportTask::DataSetImportTask(JsonView jsonValue) { *this = jsonValue; }

DataSetImportTask& DataSetImportTask::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("status")) {
    m_status = DataSetTaskLifecycleMapper::GetDataSetTaskLifecycleForName(jsonValue.GetString("status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("statusReason")) {
    m_statusReason = jsonValue.GetString("statusReason");
    m_statusReasonHasBeenSet = true;
  }
  if (jsonValue.ValueExists("summary")) {
    m_summary = jsonValue.GetObject("summary");
    m_summaryHasBeenSet = true;
  }
  if (jsonValue.ValueExists("taskId")) {
    m_taskId = jsonValue.GetString("taskId");
    m_taskIdHasBeenSet = true;
  }
  return *this;
}

JsonValue DataSetImportTask::Jsonize() const {
  JsonValue payload;

  if (m_statusHasBeenSet) {
    payload.WithString("status", DataSetTaskLifecycleMapper::GetNameForDataSetTaskLifecycle(m_status));
  }

  if (m_statusReasonHasBeenSet) {
    payload.WithString("statusReason", m_statusReason);
  }

  if (m_summaryHasBeenSet) {
    payload.WithObject("summary", m_summary.Jsonize());
  }

  if (m_taskIdHasBeenSet) {
    payload.WithString("taskId", m_taskId);
  }

  return payload;
}

}  // namespace Model
}  // namespace MainframeModernization
}  // namespace Aws
