﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mailmanager/model/CreateIngressPointRequest.h>

#include <utility>

using namespace Aws::MailManager::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateIngressPointRequest::SerializePayload() const {
  JsonValue payload;

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_ingressPointNameHasBeenSet) {
    payload.WithString("IngressPointName", m_ingressPointName);
  }

  if (m_typeHasBeenSet) {
    payload.WithString("Type", IngressPointTypeMapper::GetNameForIngressPointType(m_type));
  }

  if (m_ruleSetIdHasBeenSet) {
    payload.WithString("RuleSetId", m_ruleSetId);
  }

  if (m_trafficPolicyIdHasBeenSet) {
    payload.WithString("TrafficPolicyId", m_trafficPolicyId);
  }

  if (m_ingressPointConfigurationHasBeenSet) {
    payload.WithObject("IngressPointConfiguration", m_ingressPointConfiguration.Jsonize());
  }

  if (m_networkConfigurationHasBeenSet) {
    payload.WithObject("NetworkConfiguration", m_networkConfiguration.Jsonize());
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("Tags", std::move(tagsJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateIngressPointRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "MailManagerSvc.CreateIngressPoint"));
  return headers;
}
