﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/medical-imaging/model/CreateDatastoreRequest.h>

#include <utility>

using namespace Aws::MedicalImaging::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateDatastoreRequest::SerializePayload() const {
  JsonValue payload;

  if (m_datastoreNameHasBeenSet) {
    payload.WithString("datastoreName", m_datastoreName);
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("clientToken", m_clientToken);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("tags", std::move(tagsJsonMap));
  }

  if (m_kmsKeyArnHasBeenSet) {
    payload.WithString("kmsKeyArn", m_kmsKeyArn);
  }

  if (m_lambdaAuthorizerArnHasBeenSet) {
    payload.WithString("lambdaAuthorizerArn", m_lambdaAuthorizerArn);
  }

  if (m_losslessStorageFormatHasBeenSet) {
    payload.WithString("losslessStorageFormat", LosslessStorageFormatMapper::GetNameForLosslessStorageFormat(m_losslessStorageFormat));
  }

  return payload.View().WriteReadable();
}
