﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/medical-imaging/model/GetImageFrameRequest.h>

#include <utility>

using namespace Aws::MedicalImaging::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetImageFrameRequest::SerializePayload() const {
  JsonValue payload;

  if (m_imageFrameInformationHasBeenSet) {
    payload = m_imageFrameInformation.Jsonize();
  }

  return payload.View().WriteReadable();
}
