﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/medical-imaging/model/GetImageSetRequest.h>

#include <utility>

using namespace Aws::MedicalImaging::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String GetImageSetRequest::SerializePayload() const { return {}; }

void GetImageSetRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_versionIdHasBeenSet) {
    ss << m_versionId;
    uri.AddQueryStringParameter("version", ss.str());
    ss.str("");
  }
}
