﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/medical-imaging/model/Operator.h>

using namespace Aws::Utils;

namespace Aws {
namespace MedicalImaging {
namespace Model {
namespace OperatorMapper {

static const int EQUAL_HASH = HashingUtils::HashString("EQUAL");
static const int BETWEEN_HASH = HashingUtils::HashString("BETWEEN");

Operator GetOperatorForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == EQUAL_HASH) {
    return Operator::EQUAL;
  } else if (hashCode == BETWEEN_HASH) {
    return Operator::BETWEEN;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<Operator>(hashCode);
  }

  return Operator::NOT_SET;
}

Aws::String GetNameForOperator(Operator enumValue) {
  switch (enumValue) {
    case Operator::NOT_SET:
      return {};
    case Operator::EQUAL:
      return "EQUAL";
    case Operator::BETWEEN:
      return "BETWEEN";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace OperatorMapper
}  // namespace Model
}  // namespace MedicalImaging
}  // namespace Aws
