﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/memorydb/model/CreateMultiRegionClusterRequest.h>

#include <utility>

using namespace Aws::MemoryDB::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateMultiRegionClusterRequest::SerializePayload() const {
  JsonValue payload;

  if (m_multiRegionClusterNameSuffixHasBeenSet) {
    payload.WithString("MultiRegionClusterNameSuffix", m_multiRegionClusterNameSuffix);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("Description", m_description);
  }

  if (m_engineHasBeenSet) {
    payload.WithString("Engine", m_engine);
  }

  if (m_engineVersionHasBeenSet) {
    payload.WithString("EngineVersion", m_engineVersion);
  }

  if (m_nodeTypeHasBeenSet) {
    payload.WithString("NodeType", m_nodeType);
  }

  if (m_multiRegionParameterGroupNameHasBeenSet) {
    payload.WithString("MultiRegionParameterGroupName", m_multiRegionParameterGroupName);
  }

  if (m_numShardsHasBeenSet) {
    payload.WithInteger("NumShards", m_numShards);
  }

  if (m_tLSEnabledHasBeenSet) {
    payload.WithBool("TLSEnabled", m_tLSEnabled);
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("Tags", std::move(tagsJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateMultiRegionClusterRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonMemoryDB.CreateMultiRegionCluster"));
  return headers;
}
