﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/memorydb/model/DescribeMultiRegionClustersRequest.h>

#include <utility>

using namespace Aws::MemoryDB::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeMultiRegionClustersRequest::SerializePayload() const {
  JsonValue payload;

  if (m_multiRegionClusterNameHasBeenSet) {
    payload.WithString("MultiRegionClusterName", m_multiRegionClusterName);
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("MaxResults", m_maxResults);
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("NextToken", m_nextToken);
  }

  if (m_showClusterDetailsHasBeenSet) {
    payload.WithBool("ShowClusterDetails", m_showClusterDetails);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeMultiRegionClustersRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonMemoryDB.DescribeMultiRegionClusters"));
  return headers;
}
