﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/memorydb/model/DescribeMultiRegionClustersResult.h>

#include <utility>

using namespace Aws::MemoryDB::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeMultiRegionClustersResult::DescribeMultiRegionClustersResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

DescribeMultiRegionClustersResult& DescribeMultiRegionClustersResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("MultiRegionClusters")) {
    Aws::Utils::Array<JsonView> multiRegionClustersJsonList = jsonValue.GetArray("MultiRegionClusters");
    for (unsigned multiRegionClustersIndex = 0; multiRegionClustersIndex < multiRegionClustersJsonList.GetLength();
         ++multiRegionClustersIndex) {
      m_multiRegionClusters.push_back(multiRegionClustersJsonList[multiRegionClustersIndex].AsObject());
    }
    m_multiRegionClustersHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
