﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/memorydb/model/Endpoint.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MemoryDB {
namespace Model {

Endpoint::Endpoint(JsonView jsonValue) { *this = jsonValue; }

Endpoint& Endpoint::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Address")) {
    m_address = jsonValue.GetString("Address");
    m_addressHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Port")) {
    m_port = jsonValue.GetInteger("Port");
    m_portHasBeenSet = true;
  }
  return *this;
}

JsonValue Endpoint::Jsonize() const {
  JsonValue payload;

  if (m_addressHasBeenSet) {
    payload.WithString("Address", m_address);
  }

  if (m_portHasBeenSet) {
    payload.WithInteger("Port", m_port);
  }

  return payload;
}

}  // namespace Model
}  // namespace MemoryDB
}  // namespace Aws
