﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mgn/model/DescribeReplicationConfigurationTemplatesRequest.h>

#include <utility>

using namespace Aws::mgn::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeReplicationConfigurationTemplatesRequest::SerializePayload() const {
  JsonValue payload;

  if (m_replicationConfigurationTemplateIDsHasBeenSet) {
    Aws::Utils::Array<JsonValue> replicationConfigurationTemplateIDsJsonList(m_replicationConfigurationTemplateIDs.size());
    for (unsigned replicationConfigurationTemplateIDsIndex = 0;
         replicationConfigurationTemplateIDsIndex < replicationConfigurationTemplateIDsJsonList.GetLength();
         ++replicationConfigurationTemplateIDsIndex) {
      replicationConfigurationTemplateIDsJsonList[replicationConfigurationTemplateIDsIndex].AsString(
          m_replicationConfigurationTemplateIDs[replicationConfigurationTemplateIDsIndex]);
    }
    payload.WithArray("replicationConfigurationTemplateIDs", std::move(replicationConfigurationTemplateIDsJsonList));
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("maxResults", m_maxResults);
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("nextToken", m_nextToken);
  }

  return payload.View().WriteReadable();
}
