﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mgn/model/LifeCycleLastCutover.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace mgn {
namespace Model {

LifeCycleLastCutover::LifeCycleLastCutover(JsonView jsonValue) { *this = jsonValue; }

LifeCycleLastCutover& LifeCycleLastCutover::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("initiated")) {
    m_initiated = jsonValue.GetObject("initiated");
    m_initiatedHasBeenSet = true;
  }
  if (jsonValue.ValueExists("reverted")) {
    m_reverted = jsonValue.GetObject("reverted");
    m_revertedHasBeenSet = true;
  }
  if (jsonValue.ValueExists("finalized")) {
    m_finalized = jsonValue.GetObject("finalized");
    m_finalizedHasBeenSet = true;
  }
  return *this;
}

JsonValue LifeCycleLastCutover::Jsonize() const {
  JsonValue payload;

  if (m_initiatedHasBeenSet) {
    payload.WithObject("initiated", m_initiated.Jsonize());
  }

  if (m_revertedHasBeenSet) {
    payload.WithObject("reverted", m_reverted.Jsonize());
  }

  if (m_finalizedHasBeenSet) {
    payload.WithObject("finalized", m_finalized.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace mgn
}  // namespace Aws
