﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mgn/model/NetworkInterface.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace mgn {
namespace Model {

NetworkInterface::NetworkInterface(JsonView jsonValue) { *this = jsonValue; }

NetworkInterface& NetworkInterface::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("macAddress")) {
    m_macAddress = jsonValue.GetString("macAddress");
    m_macAddressHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ips")) {
    Aws::Utils::Array<JsonView> ipsJsonList = jsonValue.GetArray("ips");
    for (unsigned ipsIndex = 0; ipsIndex < ipsJsonList.GetLength(); ++ipsIndex) {
      m_ips.push_back(ipsJsonList[ipsIndex].AsString());
    }
    m_ipsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("isPrimary")) {
    m_isPrimary = jsonValue.GetBool("isPrimary");
    m_isPrimaryHasBeenSet = true;
  }
  return *this;
}

JsonValue NetworkInterface::Jsonize() const {
  JsonValue payload;

  if (m_macAddressHasBeenSet) {
    payload.WithString("macAddress", m_macAddress);
  }

  if (m_ipsHasBeenSet) {
    Aws::Utils::Array<JsonValue> ipsJsonList(m_ips.size());
    for (unsigned ipsIndex = 0; ipsIndex < ipsJsonList.GetLength(); ++ipsIndex) {
      ipsJsonList[ipsIndex].AsString(m_ips[ipsIndex]);
    }
    payload.WithArray("ips", std::move(ipsJsonList));
  }

  if (m_isPrimaryHasBeenSet) {
    payload.WithBool("isPrimary", m_isPrimary);
  }

  return payload;
}

}  // namespace Model
}  // namespace mgn
}  // namespace Aws
