﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mgn/model/SsmParameterStoreParameter.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace mgn {
namespace Model {

SsmParameterStoreParameter::SsmParameterStoreParameter(JsonView jsonValue) { *this = jsonValue; }

SsmParameterStoreParameter& SsmParameterStoreParameter::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("parameterType")) {
    m_parameterType = SsmParameterStoreParameterTypeMapper::GetSsmParameterStoreParameterTypeForName(jsonValue.GetString("parameterType"));
    m_parameterTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("parameterName")) {
    m_parameterName = jsonValue.GetString("parameterName");
    m_parameterNameHasBeenSet = true;
  }
  return *this;
}

JsonValue SsmParameterStoreParameter::Jsonize() const {
  JsonValue payload;

  if (m_parameterTypeHasBeenSet) {
    payload.WithString("parameterType", SsmParameterStoreParameterTypeMapper::GetNameForSsmParameterStoreParameterType(m_parameterType));
  }

  if (m_parameterNameHasBeenSet) {
    payload.WithString("parameterName", m_parameterName);
  }

  return payload;
}

}  // namespace Model
}  // namespace mgn
}  // namespace Aws
