﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mgn/model/UpdateLaunchConfigurationRequest.h>

#include <utility>

using namespace Aws::mgn::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateLaunchConfigurationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_sourceServerIDHasBeenSet) {
    payload.WithString("sourceServerID", m_sourceServerID);
  }

  if (m_nameHasBeenSet) {
    payload.WithString("name", m_name);
  }

  if (m_launchDispositionHasBeenSet) {
    payload.WithString("launchDisposition", LaunchDispositionMapper::GetNameForLaunchDisposition(m_launchDisposition));
  }

  if (m_targetInstanceTypeRightSizingMethodHasBeenSet) {
    payload.WithString(
        "targetInstanceTypeRightSizingMethod",
        TargetInstanceTypeRightSizingMethodMapper::GetNameForTargetInstanceTypeRightSizingMethod(m_targetInstanceTypeRightSizingMethod));
  }

  if (m_copyPrivateIpHasBeenSet) {
    payload.WithBool("copyPrivateIp", m_copyPrivateIp);
  }

  if (m_copyTagsHasBeenSet) {
    payload.WithBool("copyTags", m_copyTags);
  }

  if (m_licensingHasBeenSet) {
    payload.WithObject("licensing", m_licensing.Jsonize());
  }

  if (m_bootModeHasBeenSet) {
    payload.WithString("bootMode", BootModeMapper::GetNameForBootMode(m_bootMode));
  }

  if (m_postLaunchActionsHasBeenSet) {
    payload.WithObject("postLaunchActions", m_postLaunchActions.Jsonize());
  }

  if (m_enableMapAutoTaggingHasBeenSet) {
    payload.WithBool("enableMapAutoTagging", m_enableMapAutoTagging);
  }

  if (m_mapAutoTaggingMpeIDHasBeenSet) {
    payload.WithString("mapAutoTaggingMpeID", m_mapAutoTaggingMpeID);
  }

  if (m_accountIDHasBeenSet) {
    payload.WithString("accountID", m_accountID);
  }

  return payload.View().WriteReadable();
}
