﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mq/model/CreateUserRequest.h>

#include <utility>

using namespace Aws::MQ::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateUserRequest::SerializePayload() const {
  JsonValue payload;

  if (m_consoleAccessHasBeenSet) {
    payload.WithBool("consoleAccess", m_consoleAccess);
  }

  if (m_groupsHasBeenSet) {
    Aws::Utils::Array<JsonValue> groupsJsonList(m_groups.size());
    for (unsigned groupsIndex = 0; groupsIndex < groupsJsonList.GetLength(); ++groupsIndex) {
      groupsJsonList[groupsIndex].AsString(m_groups[groupsIndex]);
    }
    payload.WithArray("groups", std::move(groupsJsonList));
  }

  if (m_passwordHasBeenSet) {
    payload.WithString("password", m_password);
  }

  if (m_replicationUserHasBeenSet) {
    payload.WithBool("replicationUser", m_replicationUser);
  }

  return payload.View().WriteReadable();
}
