﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/mq/model/DescribeUserResult.h>

#include <utility>

using namespace Aws::MQ::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeUserResult::DescribeUserResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeUserResult& DescribeUserResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("brokerId")) {
    m_brokerId = jsonValue.GetString("brokerId");
    m_brokerIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("consoleAccess")) {
    m_consoleAccess = jsonValue.GetBool("consoleAccess");
    m_consoleAccessHasBeenSet = true;
  }
  if (jsonValue.ValueExists("groups")) {
    Aws::Utils::Array<JsonView> groupsJsonList = jsonValue.GetArray("groups");
    for (unsigned groupsIndex = 0; groupsIndex < groupsJsonList.GetLength(); ++groupsIndex) {
      m_groups.push_back(groupsJsonList[groupsIndex].AsString());
    }
    m_groupsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("pending")) {
    m_pending = jsonValue.GetObject("pending");
    m_pendingHasBeenSet = true;
  }
  if (jsonValue.ValueExists("username")) {
    m_username = jsonValue.GetString("username");
    m_usernameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("replicationUser")) {
    m_replicationUser = jsonValue.GetBool("replicationUser");
    m_replicationUserHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
