﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/observabilityadmin/model/DestinationType.h>

using namespace Aws::Utils;

namespace Aws {
namespace ObservabilityAdmin {
namespace Model {
namespace DestinationTypeMapper {

static const int cloud_watch_logs_HASH = HashingUtils::HashString("cloud-watch-logs");

DestinationType GetDestinationTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == cloud_watch_logs_HASH) {
    return DestinationType::cloud_watch_logs;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<DestinationType>(hashCode);
  }

  return DestinationType::NOT_SET;
}

Aws::String GetNameForDestinationType(DestinationType enumValue) {
  switch (enumValue) {
    case DestinationType::NOT_SET:
      return {};
    case DestinationType::cloud_watch_logs:
      return "cloud-watch-logs";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace DestinationTypeMapper
}  // namespace Model
}  // namespace ObservabilityAdmin
}  // namespace Aws
