﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/observabilityadmin/model/ListResourceTelemetryResult.h>

#include <utility>

using namespace Aws::ObservabilityAdmin::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListResourceTelemetryResult::ListResourceTelemetryResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListResourceTelemetryResult& ListResourceTelemetryResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("TelemetryConfigurations")) {
    Aws::Utils::Array<JsonView> telemetryConfigurationsJsonList = jsonValue.GetArray("TelemetryConfigurations");
    for (unsigned telemetryConfigurationsIndex = 0; telemetryConfigurationsIndex < telemetryConfigurationsJsonList.GetLength();
         ++telemetryConfigurationsIndex) {
      m_telemetryConfigurations.push_back(telemetryConfigurationsJsonList[telemetryConfigurationsIndex].AsObject());
    }
    m_telemetryConfigurationsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
