﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/partnercentral-selling/model/ListResourceSnapshotsResult.h>

#include <utility>

using namespace Aws::PartnerCentralSelling::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListResourceSnapshotsResult::ListResourceSnapshotsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListResourceSnapshotsResult& ListResourceSnapshotsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("ResourceSnapshotSummaries")) {
    Aws::Utils::Array<JsonView> resourceSnapshotSummariesJsonList = jsonValue.GetArray("ResourceSnapshotSummaries");
    for (unsigned resourceSnapshotSummariesIndex = 0; resourceSnapshotSummariesIndex < resourceSnapshotSummariesJsonList.GetLength();
         ++resourceSnapshotSummariesIndex) {
      m_resourceSnapshotSummaries.push_back(resourceSnapshotSummariesJsonList[resourceSnapshotSummariesIndex].AsObject());
    }
    m_resourceSnapshotSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
