﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/pinpoint-sms-voice-v2/model/ListPoolOriginationIdentitiesResult.h>

#include <utility>

using namespace Aws::PinpointSMSVoiceV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListPoolOriginationIdentitiesResult::ListPoolOriginationIdentitiesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListPoolOriginationIdentitiesResult& ListPoolOriginationIdentitiesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("PoolArn")) {
    m_poolArn = jsonValue.GetString("PoolArn");
    m_poolArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("PoolId")) {
    m_poolId = jsonValue.GetString("PoolId");
    m_poolIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("OriginationIdentities")) {
    Aws::Utils::Array<JsonView> originationIdentitiesJsonList = jsonValue.GetArray("OriginationIdentities");
    for (unsigned originationIdentitiesIndex = 0; originationIdentitiesIndex < originationIdentitiesJsonList.GetLength();
         ++originationIdentitiesIndex) {
      m_originationIdentities.push_back(originationIdentitiesJsonList[originationIdentitiesIndex].AsObject());
    }
    m_originationIdentitiesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
