﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/pinpoint/model/CreateEmailTemplateRequest.h>

#include <utility>

using namespace Aws::Pinpoint::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateEmailTemplateRequest::SerializePayload() const {
  JsonValue payload;

  if (m_emailTemplateRequestHasBeenSet) {
    payload = m_emailTemplateRequest.Jsonize();
  }

  return payload.View().WriteReadable();
}
