﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/pinpoint/model/DefaultPushNotificationMessage.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Pinpoint {
namespace Model {

DefaultPushNotificationMessage::DefaultPushNotificationMessage(JsonView jsonValue) { *this = jsonValue; }

DefaultPushNotificationMessage& DefaultPushNotificationMessage::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Action")) {
    m_action = ActionMapper::GetActionForName(jsonValue.GetString("Action"));
    m_actionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Body")) {
    m_body = jsonValue.GetString("Body");
    m_bodyHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Data")) {
    Aws::Map<Aws::String, JsonView> dataJsonMap = jsonValue.GetObject("Data").GetAllObjects();
    for (auto& dataItem : dataJsonMap) {
      m_data[dataItem.first] = dataItem.second.AsString();
    }
    m_dataHasBeenSet = true;
  }
  if (jsonValue.ValueExists("SilentPush")) {
    m_silentPush = jsonValue.GetBool("SilentPush");
    m_silentPushHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Substitutions")) {
    Aws::Map<Aws::String, JsonView> substitutionsJsonMap = jsonValue.GetObject("Substitutions").GetAllObjects();
    for (auto& substitutionsItem : substitutionsJsonMap) {
      Aws::Utils::Array<JsonView> listOf__stringJsonList = substitutionsItem.second.AsArray();
      Aws::Vector<Aws::String> listOf__stringList;
      listOf__stringList.reserve((size_t)listOf__stringJsonList.GetLength());
      for (unsigned listOf__stringIndex = 0; listOf__stringIndex < listOf__stringJsonList.GetLength(); ++listOf__stringIndex) {
        listOf__stringList.push_back(listOf__stringJsonList[listOf__stringIndex].AsString());
      }
      m_substitutions[substitutionsItem.first] = std::move(listOf__stringList);
    }
    m_substitutionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Title")) {
    m_title = jsonValue.GetString("Title");
    m_titleHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Url")) {
    m_url = jsonValue.GetString("Url");
    m_urlHasBeenSet = true;
  }
  return *this;
}

JsonValue DefaultPushNotificationMessage::Jsonize() const {
  JsonValue payload;

  if (m_actionHasBeenSet) {
    payload.WithString("Action", ActionMapper::GetNameForAction(m_action));
  }

  if (m_bodyHasBeenSet) {
    payload.WithString("Body", m_body);
  }

  if (m_dataHasBeenSet) {
    JsonValue dataJsonMap;
    for (auto& dataItem : m_data) {
      dataJsonMap.WithString(dataItem.first, dataItem.second);
    }
    payload.WithObject("Data", std::move(dataJsonMap));
  }

  if (m_silentPushHasBeenSet) {
    payload.WithBool("SilentPush", m_silentPush);
  }

  if (m_substitutionsHasBeenSet) {
    JsonValue substitutionsJsonMap;
    for (auto& substitutionsItem : m_substitutions) {
      Aws::Utils::Array<JsonValue> listOf__stringJsonList(substitutionsItem.second.size());
      for (unsigned listOf__stringIndex = 0; listOf__stringIndex < listOf__stringJsonList.GetLength(); ++listOf__stringIndex) {
        listOf__stringJsonList[listOf__stringIndex].AsString(substitutionsItem.second[listOf__stringIndex]);
      }
      substitutionsJsonMap.WithArray(substitutionsItem.first, std::move(listOf__stringJsonList));
    }
    payload.WithObject("Substitutions", std::move(substitutionsJsonMap));
  }

  if (m_titleHasBeenSet) {
    payload.WithString("Title", m_title);
  }

  if (m_urlHasBeenSet) {
    payload.WithString("Url", m_url);
  }

  return payload;
}

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
