﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/pinpoint/model/GetEmailTemplateRequest.h>

#include <utility>

using namespace Aws::Pinpoint::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String GetEmailTemplateRequest::SerializePayload() const { return {}; }

void GetEmailTemplateRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_versionHasBeenSet) {
    ss << m_version;
    uri.AddQueryStringParameter("version", ss.str());
    ss.str("");
  }
}
