﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/pinpoint/model/PutEventsRequest.h>

#include <utility>

using namespace Aws::Pinpoint::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String PutEventsRequest::SerializePayload() const {
  JsonValue payload;

  if (m_eventsRequestHasBeenSet) {
    payload = m_eventsRequest.Jsonize();
  }

  return payload.View().WriteReadable();
}
