﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/polly/model/PutLexiconRequest.h>

#include <utility>

using namespace Aws::Polly::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String PutLexiconRequest::SerializePayload() const {
  JsonValue payload;

  if (m_contentHasBeenSet) {
    payload.WithString("Content", m_content);
  }

  return payload.View().WriteReadable();
}
