﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/polly/model/SynthesizeSpeechResult.h>

#include <utility>

using namespace Aws::Polly::Model;
using namespace Aws::Utils::Stream;
using namespace Aws::Utils;
using namespace Aws;

SynthesizeSpeechResult::SynthesizeSpeechResult(Aws::AmazonWebServiceResult<ResponseStream>&& result) { *this = std::move(result); }

SynthesizeSpeechResult& SynthesizeSpeechResult::operator=(Aws::AmazonWebServiceResult<ResponseStream>&& result) {
  m_audioStream = result.TakeOwnershipOfPayload();
  m_audioStreamHasBeenSet = true;

  const auto& headers = result.GetHeaderValueCollection();
  const auto& contentTypeIter = headers.find("content-type");
  if (contentTypeIter != headers.end()) {
    m_contentType = contentTypeIter->second;
    m_contentTypeHasBeenSet = true;
  }

  const auto& requestCharactersIter = headers.find("x-amzn-requestcharacters");
  if (requestCharactersIter != headers.end()) {
    m_requestCharacters = StringUtils::ConvertToInt32(requestCharactersIter->second.c_str());
    m_requestCharactersHasBeenSet = true;
  }

  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
